//---------------------------------------------------------------------------

#pragma hdrstop

#include "Bezier.h"

#include <System.hpp>
#include <gl.h>

//---------------------------------------------------------------------------

#pragma package(smart_init)

void KrzywaBeziera(int ilePunktowKontrolnych,float punktyKontrolne[][3],bool rysujPunktyKontrolne=false)
{
	//rysowanie punktow kontrolnych
	if (rysujPunktyKontrolne)
	{
		//glPointSize(2.0f);
		//glBegin(GL_POINTS);
		//linia przerywana
		glEnable(GL_LINE_STIPPLE);
		glLineStipple(5,0x5555);
		glBegin(GL_LINE_STRIP);
		for(int i=0;i<ilePunktowKontrolnych;i++)
			glVertex3fv(punktyKontrolne[i]);
		glEnd();
		glDisable(GL_LINE_STIPPLE);
	}

	float zakres_min=0.0f;
	float zakres_max=100.0f;
	glMap1f(
		GL_MAP1_VERTEX_3,		//typ generowanych danych = krzywa na plaszczyznie
		zakres_min,zakres_max,	//zakres parametru krzywej
		3,						//rozmiar punktu (w 3D bez koloru = 3)
		ilePunktowKontrolnych,
		(GLfloat*)punktyKontrolne);

	glEnable(GL_MAP1_VERTEX_3); //wlaczenie ewaluatora

	glBegin(GL_LINE_STRIP);
	for(float u=zakres_min;u<=zakres_max;u++)
	{
		glEvalCoord1f(u);
	}
	glEnd();

   glDisable(GL_MAP1_VERTEX_3); //wylaczenie ewaluatora
}


void PowierzchniaBeziera(const int ilePunktowKontrolnych[2],float* punktyKontrolne,bool rysujPunktyKontrolne=false)
{
	//rysowanie punktow kontrolnych
	if (rysujPunktyKontrolne)
	{
		glPointSize(2.0f);
		glBegin(GL_POINTS);
		for(int iu=0;iu<ilePunktowKontrolnych[0];iu++)
			for(int iv=0;iv<ilePunktowKontrolnych[1];iv++)
         {
            glVertex3fv(punktyKontrolne+(iu*ilePunktowKontrolnych[1]+iv)*3);
         }
		glEnd();
	}

	float zakres_min=0.0f;
	float zakres_max=100.0f;
	glMap2f(
		GL_MAP2_VERTEX_3,		  //typ generowanych danych = krzywa na plaszczyznie
		//parametr u
		zakres_min,zakres_max,	  //zakres parametru krzywej
		3,						  //rozmiar punktu (w 3D bez koloru = 3)
		ilePunktowKontrolnych[1],
		//parametr v
		zakres_min,zakres_max,	  //zakres parametru krzywej
		ilePunktowKontrolnych[1]*3,  //odleglosc miedzy punktami w danych dla v
		ilePunktowKontrolnych[0],
		punktyKontrolne); //punktyKontrolne);

	glEnable(GL_MAP2_VERTEX_3);     //wlaczenie ewaluatora


   /*
	//linie w jednym kierunku
	for(float u=zakres_min;u<=zakres_max;u+=10.f)
	{
		glBegin(GL_LINE_STRIP);
		for(float v=zakres_min;v<=zakres_max;v+=10.f)
		{
			glEvalCoord2f(u,v);
		}
		glEnd();
	}
	//linie w drugim kierunku
	for(float u=zakres_min;u<=zakres_max;u+=10.f)
	{
		glBegin(GL_LINE_STRIP);
		for(float v=zakres_min;v<=zakres_max;v+=10.f)
			glEvalCoord2f(v,u);
		glEnd();
	}
   */

   //automatyczne generowanie siatki i ewaluacja
   const int gestoscSiatki=30;
   glMapGrid2f(gestoscSiatki,zakres_min,zakres_max,gestoscSiatki,zakres_min,zakres_max);
   glEvalMesh2(GL_FILL,0,gestoscSiatki,0,gestoscSiatki);
}
